#ifndef FileMaker_h
#define FileMaker_h
#include "Exceptions.h"
#include <iostream>
#include <string>
#include <cmath>
#include <algorithm>
#include <fstream>
#include <vector>
#include <iterator>

void createData_1(const std::string& filePath){
    std::ofstream file(filePath, std::ios::trunc);
    if (!file.is_open())  {
        throw PathError();
    }
    srand(time(nullptr));
    for(int i = 0; i < 100; ++i){
        file << rand() % 101 - 50 << std::endl;
    }
}

void createData_2(const std::string& filePath){
    std::ofstream file(filePath, std::ios::trunc);
    if (!file.is_open())  {
        throw PathError();
    }
    srand(time(nullptr));
    
    std::vector<int> randVal(100);//!!! Функции не должны зависеть от конкретных типов. Есть value_Type.
    std::generate(randVal.begin(), randVal.end(), [](){return rand() % 101 - 50;});
    std::copy(randVal.begin(), randVal.end(), std::ostream_iterator<int>(file, "\n"));//!!! Функции не должны зависеть от конкретных типов. Есть value_Type.
}

template<class _Cont>
_Cont loadData_1(const std::string& filePath){
    _Cont result;
    std::ifstream file(filePath);
    if (!file.is_open())  {
        throw PathError();
    }
    
    int buffer; //!!! Функции не должны зависеть от конкретных типов. Есть value_Type.
    
    while (file >> buffer) {
        result.push_back(buffer);
    }
    return result;
}

template<typename _Cont>
_Cont loadData_2(const std::string& filePath) {
    _Cont result;
    std::ifstream file(filePath);
    if (!file.is_open()) {
        throw PathError();
    }
    std::istream_iterator<int> first(file);//!!! Функции не должны зависеть от конкретных типов. Есть value_Type.
    std::istream_iterator<int> last;//!!! Функции не должны зависеть от конкретных типов. Есть value_Type.
    result.resize(100);
    std::copy(first, last, result.begin());
    return result;
}

template<typename _Cont>
void Modify(_Cont& container) {
    const auto max = std::max_element(container.begin(), container.end());
    
    const double add = sqrt(abs(*max * container.back()));

    for (auto& iter : container) { iter += add; }
    double sum = 0;
    std::for_each(container.begin(), container.end(), [&sum](const auto el){
        sum += el;
    });
    container.push_back(abs(sum));
    container.push_back(abs(sum/100));
}

template<typename _Iter>
void Modify(_Iter iterBeg, _Iter iterEnd) {
    const auto max = std::max_element(iterBeg, iterEnd);
    advance(iterEnd, -1);
    const double add = sqrt(abs(*max * *(iterEnd)));
    advance(iterEnd, 1);
    for(; iterBeg != iterEnd; ++iterBeg) {
        *iterBeg += add;
    }
}

template<typename _Cont, typename _Func>
void Modify(_Cont container, _Func func) { //!!! Почему container передается по знаяению?
    std::for_each(container.begin(), container.end(), func);
}

template<class _Cont>
void Modify_Transform(_Cont& container) {
    const auto max = std::max_element(container.begin(), container.end());
    std::transform(container.begin(), container.end(), container.begin(),
        [max, container](auto& el) {return el += sqrt(abs(*max * container.back())); });
}
    
template<typename _Cont>
void outputResult_1(const _Cont& container, const std::string& resfilePath){
    std::ofstream file(resfilePath, std::ios::trunc);
    if (!file.is_open()) {
        throw PathError();
    }
    
    for(const auto& it: container){
        file << it << std::endl;
    }
}
template<typename _Cont>
void outputResult_2(const _Cont& container, const std::string& resfilePath) {
    std::ofstream file(resfilePath, std::ios::trunc);
    if (!file.is_open())  {
        throw PathError();
    }
    std::copy(container.begin(), container.end(), std::ostream_iterator<double>(file, "\n"));
}

#endif
